function Figure4D
% This script plote the data from Figure 4D. When generating the plot, a 
% logarithmic transformation is applied to the integrated intensities to 
% display shaded data in the plot clearly over a broad dynamic range.
% This transformation is not used in Figure 4E

load('Figure4D_data.mat');
% cs: C3 intensities for spherical particles
% fs: F intensities for spherical particles
% cf: C3 intensities for filaments
% ff: F intensities for filaments

CS = log10(cs+1e4) - 4; CF = log10(cf+1e4) - 4;
Q = 1/max(max(CS));

figure;
imshow(uint8(255*(1-CS))); title('RSV - globular particles');
figure
imshow(uint8(255*(1-CF))); title('RSV - filamentous particles');